%% EJEMPLO 12b: Integracin por rechazo
% Determinar el valor de pi a partir de una integracin 2D
% Estanque circular de radio r=1 inscrito en un cuadrado de lado 2
%% Re-escritura del cdigo para reducir el tiempo de cmputo
% Evita usar un bucle con el nmero de muestras N
clear

N=1e7; % Nmero de evaluaciones de la integral
Abox=2*2; % Area del cuadrado de lado 2 (2r*2r=4)

r=-1+(1+1)*rand(1,2*N); % Generacin de secuencia aleatoria en [-1,+1]
x=r(1:2:2*N-1); y=r(2:2:2*N);
d=x.^2+y.^2;
Nsamp=sign(d-1); % Si Nsamp(i)=-1 la muestra est dentro del rea
                 % Si Nsamp(i)=+1 la muestra est fuera del rea
Npond=length(find(Nsamp==-1)); % Calcula cuntos elementos de Nsamp son iguales a -1
Nbox=length(find(Nsamp==1));   % Calcula cuntos elementos de Nsamp son iguales a +1

Apond=Npond/N*Abox; % Area estimada del crculo (pi*r^2=pi)
fprintf('\n pi = %7.3f \n\n', Apond);